<?php defined('ALTUMCODE') || die() ?>

<?php ob_start() ?>
<div class="card mb-5">
    <div class="card-body">
        <h2 class="h4"><i class="fa fa-fw fa-server fa-xs text-muted"></i> <?= l('admin_statistics.campaigns.header') ?></h2>
        <div class="d-flex flex-column flex-xl-row">
            <div class="mb-2 mb-xl-0 mr-4">
                <span class="font-weight-bold"><?= nr($data->total['campaigns']) ?></span> <?= l('admin_statistics.campaigns.chart') ?>
            </div>
        </div>

        <div class="chart-container">
            <canvas id="campaigns"></canvas>
        </div>
    </div>
</div>

<?php $html = ob_get_clean() ?>

<?php ob_start() ?>
<script>
    'use strict';

    let color = css.getPropertyValue('--primary');
    let color_gradient = null;

    /* Display chart */
    let campaigns_chart = document.getElementById('campaigns').getContext('2d');
    color_gradient = campaigns_chart.createLinearGradient(0, 0, 0, 250);
    color_gradient.addColorStop(0, 'rgba(63, 136, 253, .1)');
    color_gradient.addColorStop(1, 'rgba(63, 136, 253, 0.025)');

    new Chart(campaigns_chart, {
        type: 'line',
        data: {
            labels: <?= $data->campaigns_chart['labels'] ?>,
            datasets: [
                {
                    label: <?= json_encode(l('admin_statistics.campaigns.chart')) ?>,
                    data: <?= $data->campaigns_chart['campaigns'] ?? '[]' ?>,
                    backgroundColor: color_gradient,
                    borderColor: color,
                    fill: true
                }
            ]
        },
        options: chart_options
    });
</script>
<?php $javascript = ob_get_clean() ?>

<?php return (object) ['html' => $html, 'javascript' => $javascript] ?>
