<?php defined('ALTUMCODE') || die() ?>

<div class="container">
    <nav aria-label="breadcrumb">
        <ol class="custom-breadcrumbs small">
            <li><a href="<?= url() ?>"><?= l('index.breadcrumb') ?></a> <i class="fa fa-fw fa-angle-right"></i></li>
            <li><a href="<?= url('pages') ?>"><?= l('pages.index.breadcrumb') ?></a> <i class="fa fa-fw fa-angle-right"></i></li>
            <?php if($data->page->pages_category_url): ?>
                <li><a href="<?= url('pages/' . $data->page->pages_category_url) ?>"><?= $data->page->pages_category_title ?></a> <i class="fa fa-fw fa-angle-right"></i></li>
            <?php endif ?>
            <li class="active" aria-current="page"><?= l('page.breadcrumb') ?></li>
        </ol>
    </nav>

    <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-md-between">
        <h1 class="h3"><?= $data->page->title ?></h1>

        <div class="d-print-none col-auto p-0 d-flex align-items-center">
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="window.print()"><i class="fa fa-fw fa-sm fa-print"></i> <?= l('page.print') ?></button>
        </div>
    </div>
    <p class="text-muted mb-4">
        <?php if($data->page->description): ?>
            <span class="mr-3"><?= $data->page->description ?></span>
        <?php endif ?>

        <?php $estimated_reading_time = string_estimate_reading_time($data->page->content) ?>
        <?php if($estimated_reading_time->minutes > 0 || $estimated_reading_time->seconds > 0): ?>
            <small>
                <i class="fa fa-fw fa-sm fa-hourglass-start"></i>
                <?= $estimated_reading_time->minutes ? sprintf(l('page.estimated_reading_time'), $estimated_reading_time->minutes . ' ' . l('global.date.minutes')) : null ?>
                <?= $estimated_reading_time->minutes == 0 && $estimated_reading_time->seconds ? sprintf(l('page.estimated_reading_time'), $estimated_reading_time->seconds . ' ' . l('global.date.seconds')) : null ?>
            </small>
        <?php endif ?>
    </p>

    <?= $data->page->content ?>

    <div class="mt-4">
        <small class="text-muted"><i class="fa fa-fw fa-sm fa-calendar"></i> <?= sprintf(l('page.last_datetime'), \Altum\Date::get($data->page->last_datetime, 2)) ?></small>
    </div>
</div>
